#ifndef REMAPPER_H
#define REMAPPER_H

typedef struct{
    int     materialIndex;
    int     vertexIndex;
    int     textureIndex;
    int     faceIndex;
    int     normalIndex;
    char    triIndex;	
    float   x, y, z;
    float   u, v;
    float   nx, ny, nz;
    unsigned char r, g, b, a;
}ReMapperInfo;

typedef struct{
    int faceNum;
    int index[3];
    int materialIndex;
}ReMapperFaceLoop;

typedef struct{
    int     vertexIndex;    
	int     faceIndex;
    int     normalIndex;
    int     materialIndex;
    float   u, v;
    unsigned char r, g, b, a;
}ReMapperVertex;

class ReMapper
{
public:
    ReMapper(void);
    ~ReMapper(void);

    int                 DoRemap(void);
    void                InitReMapperInfos(ReMapperInfo *infos, int numInfos);
    void                AddGroup(int shapeIndex, int groupIndex, MaterialMap *materialMap,
                            RwV3d *tVertArray, bool prelight, bool limitUVs, float uvMax);
    void                ResetReMap(void);
    int                 GetNumVertices(void);
	int					GetNumFaces(void);
    ReMapperFaceLoop *  GetFace(int faceNum);
    ReMapperVertex *    GetVertex(int vertexNum);
    void                SetNumInputFaces(int numFaces);

private:
    int                 m_numVertices;
	int					m_numFaces;
    int                 m_numAddedFaces;
    ReMapperVertex      *m_vertices;
    ReMapperFaceLoop    *m_faces;    
    ReMapperInfo        *m_remapperInfos;
    int                 *m_originalFaces;
    int                 m_numInputFaces;
};

#endif /* REMAPPER_H*/